using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgTransfusionReactionHistory
	/// </summary>
	public class DlgTransfusionReactionHistory : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.Patient _patient;
		private ArrayList _reactionHistory;
		//
		private gov.va.med.vbecs.GUI.controls.PatientDisplayPanel patientDisplayPanel2;
		private System.Windows.Forms.ColumnHeader columnHeader15;
		private System.Windows.Forms.ColumnHeader columnHeader18;
		private System.Windows.Forms.ColumnHeader columnHeader17;
		private System.Windows.Forms.GroupBox grpTransfusionReactionHistory;
		private System.Windows.Forms.ListView lvTransfusionReactionHistory;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.Panel pnlClinicalInfo;
		private System.Windows.Forms.Panel pnlPatientSelect;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.Button btnCancel;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgTransfusionReactionHistory()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgTransfusionReactionHistory(BOL.Patient patient) : this()
		{
			this.Patient = patient;
			//
			GetTransfusionReactions();
			//
			this.pnlPatientSelect.Visible = false;
			this.pnlClinicalInfo.Visible = true;
			//
			this.LoadTransfusionReactions();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgTransfusionReactionHistory));
			this.patientDisplayPanel2 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
			this.grpTransfusionReactionHistory = new System.Windows.Forms.GroupBox();
			this.lvTransfusionReactionHistory = new System.Windows.Forms.ListView();
			this.columnHeader15 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader18 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader17 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.btnClose = new System.Windows.Forms.Button();
			this.pnlClinicalInfo = new System.Windows.Forms.Panel();
			this.pnlPatientSelect = new System.Windows.Forms.Panel();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpTransfusionReactionHistory.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.pnlClinicalInfo.SuspendLayout();
			this.pnlPatientSelect.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(692, 30);
			this.vbecsLogo1.Title = "Patient Transfusion Reaction History";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// patientDisplayPanel2
			// 
			this.patientDisplayPanel2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientDisplayPanel2.EnabledBloodAvailButton = false;
			this.patientDisplayPanel2.EnabledMedicationButton = false;
			this.patientDisplayPanel2.EnabledRecentOrdersButton = false;
			this.patientDisplayPanel2.EnabledRecentTransfusionsIssuesButton = false;
			this.patientDisplayPanel2.EnabledSIAndTRButton = false;
			this.patientDisplayPanel2.EnabledTransfusionReactionHistoryButton = false;
			this.patientDisplayPanel2.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientDisplayPanel2.Location = new System.Drawing.Point(4, 0);
			this.patientDisplayPanel2.Name = "patientDisplayPanel2";
			this.patientDisplayPanel2.Patient = null;
			this.patientDisplayPanel2.Size = new System.Drawing.Size(686, 44);
			this.patientDisplayPanel2.TabIndex = 0;
			// 
			// grpTransfusionReactionHistory
			// 
			this.grpTransfusionReactionHistory.AccessibleDescription = "Transfusion Reaction History";
			this.grpTransfusionReactionHistory.AccessibleName = "Transfusion Reaction History";
			this.grpTransfusionReactionHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTransfusionReactionHistory.Controls.Add(this.lvTransfusionReactionHistory);
			this.grpTransfusionReactionHistory.Location = new System.Drawing.Point(48, 44);
			this.grpTransfusionReactionHistory.Name = "grpTransfusionReactionHistory";
			this.grpTransfusionReactionHistory.Size = new System.Drawing.Size(640, 368);
			this.grpTransfusionReactionHistory.TabIndex = 1;
			this.grpTransfusionReactionHistory.TabStop = false;
			this.grpTransfusionReactionHistory.Text = "Transfusion Reaction History";
			// 
			// lvTransfusionReactionHistory
			// 
			this.lvTransfusionReactionHistory.AccessibleDescription = "Transfusion Reaction History";
			this.lvTransfusionReactionHistory.AccessibleName = "Transfusion Reaction History";
			this.lvTransfusionReactionHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvTransfusionReactionHistory.BackColor = System.Drawing.SystemColors.Control;
			this.lvTransfusionReactionHistory.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																										   this.columnHeader15,
																										   this.columnHeader18,
																										   this.columnHeader17,
																										   this.columnHeader1});
			this.lvTransfusionReactionHistory.FullRowSelect = true;
			this.lvTransfusionReactionHistory.Location = new System.Drawing.Point(8, 16);
			this.lvTransfusionReactionHistory.MultiSelect = false;
			this.lvTransfusionReactionHistory.Name = "lvTransfusionReactionHistory";
			this.lvTransfusionReactionHistory.Size = new System.Drawing.Size(624, 344);
			this.lvTransfusionReactionHistory.TabIndex = 2;
			this.lvTransfusionReactionHistory.View = System.Windows.Forms.View.Details;
			this.lvTransfusionReactionHistory.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvTransfusionReactionHistory_ColumnClick);
			// 
			// columnHeader15
			// 
			this.columnHeader15.Text = "Transfusion Reaction Type";
			this.columnHeader15.Width = 250;
			// 
			// columnHeader18
			// 
			this.columnHeader18.Text = "Reaction Date";
			this.columnHeader18.Width = 120;
			// 
			// columnHeader17
			// 
			this.columnHeader17.Text = "Division";
			this.columnHeader17.Width = 100;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Comments";
			this.columnHeader1.Width = 140;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 44);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(40, 368);
			this.grpImage.TabIndex = 69;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(32, 36);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// btnClose
			// 
			this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnClose.Location = new System.Drawing.Point(612, 416);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 3;
			this.btnClose.Text = "&Close";
			this.btnClose.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// pnlClinicalInfo
			// 
			this.pnlClinicalInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlClinicalInfo.Controls.Add(this.grpTransfusionReactionHistory);
			this.pnlClinicalInfo.Controls.Add(this.patientDisplayPanel2);
			this.pnlClinicalInfo.Controls.Add(this.btnClose);
			this.pnlClinicalInfo.Controls.Add(this.grpImage);
			this.pnlClinicalInfo.Location = new System.Drawing.Point(0, 32);
			this.pnlClinicalInfo.Name = "pnlClinicalInfo";
			this.pnlClinicalInfo.Size = new System.Drawing.Size(692, 440);
			this.pnlClinicalInfo.TabIndex = 74;
			// 
			// pnlPatientSelect
			// 
			this.pnlPatientSelect.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlPatientSelect.Controls.Add(this.btnOK);
			this.pnlPatientSelect.Controls.Add(this.patientSelectTool1);
			this.pnlPatientSelect.Controls.Add(this.btnCancel);
			this.pnlPatientSelect.Location = new System.Drawing.Point(0, 32);
			this.pnlPatientSelect.Name = "pnlPatientSelect";
			this.pnlPatientSelect.Size = new System.Drawing.Size(692, 440);
			this.pnlPatientSelect.TabIndex = 75;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(532, 416);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 11;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// patientSelectTool1
			// 
			this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientSelectTool1.DisplaySIAndTRs = true;
			this.patientSelectTool1.EnabledBloodAvailButton = false;
			this.patientSelectTool1.EnabledMedicationButton = false;
			this.patientSelectTool1.EnabledRecentOrdersButton = false;
			this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientSelectTool1.EnabledSIAndTRButton = false;
			this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
			this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientSelectTool1.Location = new System.Drawing.Point(4, 0);
			this.patientSelectTool1.Name = "patientSelectTool1";
			this.patientSelectTool1.SearchVistaLink = false;
			this.patientSelectTool1.Size = new System.Drawing.Size(684, 412);
			this.patientSelectTool1.TabIndex = 10;
			this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
			this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(612, 416);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 12;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// DlgTransfusionReactionHistory
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(692, 473);
			this.Controls.Add(this.pnlPatientSelect);
			this.Controls.Add(this.pnlClinicalInfo);
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(700, 500);
			this.Name = "DlgTransfusionReactionHistory";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Patient Transfusion Reaction History";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgTransfusionReactionHistory_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.pnlClinicalInfo, 0);
			this.Controls.SetChildIndex(this.pnlPatientSelect, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpTransfusionReactionHistory.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.pnlClinicalInfo.ResumeLayout(false);
			this.pnlPatientSelect.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Patient
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return this._patient;
			}
			set
			{
				this._patient = value;
				this.patientDisplayPanel2.Patient = value;
				//
				this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
				this.patientDisplayPanel2.EnabledTransfusionReactionHistoryButton = false;
				//
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			this.SetThisToolTip(btnClose,Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn());
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC065.DlgRecentTransfusionsIssues());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			this.pnlPatientSelect.Visible = true;
			this.pnlClinicalInfo.Visible = false;
			//
			this.Patient = null;
			//
			this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
			this.patientDisplayPanel2.EnabledTransfusionReactionHistoryButton = false;
		}

		private void GetTransfusionReactions()
		{
			using (new WaitCursor())
			{
				if (this._patient != null)
				{
					_reactionHistory = BOL.PatientTransfusionReaction.GetTransfusionReactionsForPatient(this._patient.PatientGuid);
				}
				else
				{
					_reactionHistory = null;
				}
			}
		}

		private void LoadTransfusionReactions()
		{
			if ((_reactionHistory == null) || (_reactionHistory.Count==0))
			{
				this.lvTransfusionReactionHistory.Items.Add(new ListViewItem(Common.StrRes.InfoMsg.UC065.NoTransfusionReactions().ResString));
			}
			else
			{
				foreach(BOL.PatientTransfusionReaction reaction in _reactionHistory)
				{
					ListViewItem lvi = new ListViewItem();
					lvi.Text = reaction.TransfusionReactionTypeText;
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(reaction.NotedDateTime));
					if (reaction.RecordStatusCode == Common.RecordStatusCode.Converted)
					{
						lvi.SubItems.Add("VistA Converted");
					}
					else
					{
						BOL.Division dvsn = new BOL.Division(reaction.DivisionCode);
						lvi.SubItems.Add(dvsn.DivisionName);
					}
					string reactionComments = "";
					ArrayList comments = BOL.PatientTransfusionComment.GetComments(Guid.Empty,reaction.PatientTransfusionReactionGuid);
					if (comments != null)
					{
						foreach(BOL.PatientTransfusionComment comment in comments)
						{
							if (comment.CommentCategoryCode == "TW")
							{
								reactionComments = BOL.CannedComment.CombinedComment(comment.CannedCommentGuid, comment.PatientTransfusionCommentText);
								break;
							}
						}
					}
					lvi.SubItems.Add(reactionComments);
					this.lvTransfusionReactionHistory.Items.Add(lvi);
				}
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvTransfusionReactionHistory);
		}

		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this.Patient = null;
			this._reactionHistory = null;
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
		}

		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			this.Patient = this.patientSelectTool1.SelectedPatient;
			this.GetTransfusionReactions();
			this.btnOK.EnabledButton = true;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if ((_reactionHistory == null) || (_reactionHistory.Count==0))
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC065.NoTransfusionReactions());
				return;
			}
			this.pnlPatientSelect.Visible = false;
			this.pnlClinicalInfo.Visible = true;
			//
			this.LoadTransfusionReactions();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}


		private void lvTransfusionReactionHistory_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 1)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgTransfusionReactionHistory_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if (this.pnlPatientSelect.Visible && !this.btnOK.EnabledButton)
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			if(this.patientDisplayPanel2.Visible)
			{
				textToSpeak = this.patientDisplayPanel2.GetErrorMessagesFor508();
			}
			//
			this.SpeakMessage( textToSpeak );
		}
	}
}

